{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2004 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.SHFolder platform;

{$WEAKPACKAGEUNIT}

interface

uses
  System.Text, System.Runtime.InteropServices, Windows;

{
  functions to get shell special folders/
  shfolder.dll supports these on all platforms including Win95, Win98, NT4 and IE4 shell

  all CSIDL values refereed to here are supported natively by shfolder.dll, that is they
  will work on all platforms.
}
const
  CSIDL_PERSONAL = $0005; { My Documents }
  CSIDL_APPDATA = $001A; { Application Data, new for NT4 }

  CSIDL_LOCAL_APPDATA = $001C; { non roaming, user\Local Settings\Application Data }
  CSIDL_INTERNET_CACHE = $0020;
  CSIDL_COOKIES = $0021;
  CSIDL_HISTORY = $0022;
  CSIDL_COMMON_APPDATA = $0023; { All Users\Application Data }
  CSIDL_WINDOWS = $0024; { GetWindowsDirectory() }
  CSIDL_SYSTEM = $0025; { GetSystemDirectory() }
  CSIDL_PROGRAM_FILES = $0026; { C:\Program Files }
  CSIDL_MYPICTURES = $0027; { My Pictures, new for Win2K }
  CSIDL_PROGRAM_FILES_COMMON = $002b; { C:\Program Files\Common }
  CSIDL_COMMON_DOCUMENTS = $002e; { All Users\Documents }

  CSIDL_FLAG_CREATE = $8000; { new for Win2K, or this in to force creation of folder }

  CSIDL_COMMON_ADMINTOOLS = $002f; { All Users\Start Menu\Programs\Administrative Tools }
  CSIDL_ADMINTOOLS = $0030; { <user name>\Start Menu\Programs\Administrative Tools }

  function SHGetFolderPath(hwnd: HWND; csidl: Integer; hToken: THandle; dwFlags: DWord; pszPath: StringBuilder): HRESULT;
  function SHGetFolderPathA(hwnd: HWND; csidl: Integer; hToken: THandle; dwFlags: DWord; pszPath: StringBuilder): HRESULT;
  function SHGetFolderPathW(hwnd: HWND; csidl: Integer; hToken: THandle; dwFlags: DWord; pszPath: StringBuilder): HRESULT;

type
  PFNSHGETFOLDERPATH = function(hwnd: HWND; csidl: Integer; hToken: THandle; dwFlags: DWord; pszPath: StringBuilder): HRESULT;
  PFNSHGETFOLDERPATHA = function(hwnd: HWND; csidl: Integer; hToken: THandle; dwFlags: DWord; pszPath: StringBuilder): HRESULT;
  PFNSHGETFOLDERPATHW = function(hwnd: HWND; csidl: Integer; hToken: THandle; dwFlags: DWord; pszPath: StringBuilder): HRESULT;

  TSHGetFolderPath = PFNSHGETFOLDERPATH;
  TSHGetFolderPathA = PFNSHGETFOLDERPATHA;
  TSHGetFolderPathW = PFNSHGETFOLDERPATHW;

implementation

uses
  System.Security;

const
  SHFolderDll = 'SHFolder.dll';

[SuppressUnmanagedCodeSecurity, DllImport(SHFolderDll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SHGetFolderPath')]
function SHGetFolderPath; external;
[SuppressUnmanagedCodeSecurity, DllImport(SHFolderDll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SHGetFolderPathA')]
function SHGetFolderPathA; external;
[SuppressUnmanagedCodeSecurity, DllImport(SHFolderDll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SHGetFolderPathW')]
function SHGetFolderPathW; external;

end.
